# Introduction ======

#We are going to put the code used to make figure 5 (EEG-behaviour interaction) here - because we are doing some cluster correction, 
#we are going to have a separate stats script and a plotting script

# Set up ----

## Load packages and metadata ---------

#Load packages
pacman::p_load(tidyverse,patchwork,ghibli,eegUtils,
               emmeans,lme4,lmerTest,broom.mixed)


#Get our default settings
source("./eLife Submission Scripts/Analysis-Common-Utilities.R")



## Load EEG data ----- 

#Load the EEG summary data
d_sum = 
  readr::read_rds("./eLife Submission Data/sleep_study_eeg_summary_data_z.rds")


#Remove the angle data
d_sum = 
  d_sum |>
  filter(measure != "itpc_overlap_angle")


# Cluster Corrected interaction models =======

#Use a subset of measures based on our results
exposures_eeg = c("cons_REM","spin_amp","so_amp","itpc_overlap_mag_z")


#Fit models and correct with cluster correction...
m_binom_60 =
  d_sum |>
  filter(measure %in% exposures_eeg | (measure == "cons" & stage == "REM") ) |>
  unnest(data) |>
  left_join(meta |> select(subject, hits_morning),by = "subject") |>
  mutate(m_s = interaction(measure,stage,sep = "_")) %>%
  mutate(m_s = map_chr(m_s,str_remove,"_N2&N3")) %>%
  mutate(m_s = factor(m_s, levels = c("cons_REM","spin_amp","so_amp","itpc_overlap_mag_z"))) |>
  group_by(m_s) |>
  nest() |>
  mutate(clus = map(data,cluster_correct_interaction,
                    neighbours = d_neighbours,
                    group_var = "electrode",totperm = 500,clus_alpha = 0.025, montecarlo_alpha = 0.05))


#Save our cluster data
write_rds(m_binom_60,"./elife Submission Data/sleep_study_interaction_clusters.rds")

# By electrode fitted values ======

#We also need the model fitted values
mod_binom_60 = 
  m_binom_60 |>
  select(-clus) |>
  ungroup() |>
  unnest(data) |>
  group_by(m_s,electrode) |>
  nest() |>
  mutate(
    models = map(data, ~glmer(cbind(hits_morning, 15 - hits_morning) ~ value*group + age_eeg + gender + (1|family),
                              data = .x,family = binomial())),

    e_trend = map(models, ~emtrends(.x, pairwise ~ group, var = "value", infer = T,
                                    adjust = "bonferroni", type = "response",trans = "log")),

    e_table = map(e_trend, ~.x$contrasts %>% as_tibble() %>% rename(lower.CL = asymp.LCL,upper.CL = asymp.UCL))
  )

write_rds(mod_binom_60,"./elife Submission Data/sleep_study_interaction_models.rds")


